<?php
include 'koneksi.php';

// AMBIL DATA STATISTIK UNTUK LANDING PAGE
$jml_siswa = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM siswa WHERE status='Aktif'"));
$jml_guru  = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM guru"));
$jml_kelas = mysqli_num_rows(mysqli_query($koneksi, "SELECT DISTINCT kelas FROM siswa"));
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMA 1 CONTOH - Berprestasi & Berkarakter</title>
    
    <!-- CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet"> <!-- Animasi Scroll -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">

    <style>
        body { font-family: 'Poppins', sans-serif; overflow-x: hidden; }
        
        /* NAVBAR */
        .navbar { transition: all 0.3s; padding: 15px 0; }
        .navbar-scrolled { background: #fff; box-shadow: 0 5px 20px rgba(0,0,0,0.1); padding: 10px 0; }
        .navbar-scrolled .nav-link { color: #333 !important; }
        .navbar-scrolled .navbar-brand { color: #0d6efd !important; }
        
        /* HERO SECTION */
        .hero {
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.6)), url('https://images.unsplash.com/photo-1580582932707-520aed937b7b?q=80&w=1600') center/cover;
            height: 100vh;
            display: flex;
            align-items: center;
            color: white;
        }
        
        /* CARDS */
        .feature-box {
            padding: 30px;
            border-radius: 15px;
            background: white;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            transition: 0.3s;
            height: 100%;
        }
        .feature-box:hover { transform: translateY(-10px); box-shadow: 0 15px 40px rgba(0,0,0,0.1); }
        .icon-box {
            width: 60px; height: 60px;
            background: #e7f1ff; color: #0d6efd;
            border-radius: 50%;
            display: flex; align-items: center; justify-content: center;
            font-size: 24px; margin-bottom: 20px;
        }

        /* STATS */
        .counter-section {
            background: linear-gradient(45deg, #0d6efd, #0dcaf0);
            color: white;
            padding: 60px 0;
        }
    </style>
</head>
<body>

    <!-- NAVBAR -->
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top">
        <div class="container">
            <a class="navbar-brand fw-bold d-flex align-items-center" href="#">
                <img src="logo.jpg" onerror="this.src='https://via.placeholder.com/40'" class="rounded-circle me-2" style="width: 40px; height: 40px;">
                SMA 1 CONTOH
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link text-white active" href="#home">Beranda</a></li>
                    <li class="nav-item"><a class="nav-link text-white" href="#tentang">Tentang</a></li>
                    <li class="nav-item"><a class="nav-link text-white" href="#pengumuman">Pengumuman</a></li>
                    <li class="nav-item ms-3">
                        <a href="login.php" class="btn btn-light fw-bold rounded-pill px-4">Login Portal <i class="bi bi-arrow-right"></i></a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- HERO SECTION -->
    <section id="home" class="hero text-center">
        <div class="container" data-aos="fade-up">
            <h1 class="display-3 fw-bold mb-3">Mewujudkan Generasi <br> <span class="text-info">Cerdas & Berkarakter</span></h1>
            <p class="lead mb-4 opacity-75">Sistem Informasi Manajemen Sekolah Terpadu untuk masa depan pendidikan yang lebih baik.</p>
            <a href="#tentang" class="btn btn-primary btn-lg rounded-pill px-5 me-2">Selengkapnya</a>
            <a href="index.php" class="btn btn-outline-light btn-lg rounded-pill px-5">Login Siswa</a>
        </div>
    </section>

    <!-- FEATURES -->
    <section id="tentang" class="py-5">
        <div class="container py-5">
            <div class="row g-4">
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
                    <div class="feature-box">
                        <div class="icon-box"><i class="bi bi-trophy-fill"></i></div>
                        <h5>Akreditasi A</h5>
                        <p class="text-muted">Sekolah dengan standar kualitas pendidikan terbaik dan fasilitas penunjang yang lengkap.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
                    <div class="feature-box">
                        <div class="icon-box"><i class="bi bi-people-fill"></i></div>
                        <h5>Pengajar Profesional</h5>
                        <p class="text-muted">Didukung oleh tenaga pendidik bersertifikasi dan berpengalaman di bidangnya.</p>
                    </div>
                </div>
                <div class="col-md-4" data-aos="fade-up" data-aos-delay="300">
                    <div class="feature-box">
                        <div class="icon-box"><i class="bi bi-laptop"></i></div>
                        <h5>Digital System</h5>
                        <p class="text-muted">Penerapan teknologi informasi dalam absensi, penilaian, dan administrasi sekolah.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- STATS COUNTER (DATA DARI DATABASE) -->
    <section class="counter-section">
        <div class="container text-center">
            <div class="row g-4">
                <div class="col-md-4" data-aos="zoom-in">
                    <h1 class="display-4 fw-bold"><?= $jml_siswa ?></h1>
                    <p class="h5 opacity-75">Siswa Aktif</p>
                </div>
                <div class="col-md-4" data-aos="zoom-in" data-aos-delay="100">
                    <h1 class="display-4 fw-bold"><?= $jml_guru ?></h1>
                    <p class="h5 opacity-75">Guru & Staff</p>
                </div>
                <div class="col-md-4" data-aos="zoom-in" data-aos-delay="200">
                    <h1 class="display-4 fw-bold"><?= $jml_kelas ?></h1>
                    <p class="h5 opacity-75">Total Kelas</p>
                </div>
            </div>
        </div>
    </section>

    <!-- PENGUMUMAN TERBARU -->
    <section id="pengumuman" class="py-5 bg-light">
        <div class="container py-5">
            <div class="text-center mb-5">
                <h6 class="text-primary fw-bold text-uppercase">Informasi Terbaru</h6>
                <h2 class="fw-bold">Papan Pengumuman Sekolah</h2>
            </div>

            <div class="row g-4">
                <?php
                // Ambil 3 Pengumuman Terakhir
                $q_info = mysqli_query($koneksi, "SELECT * FROM pengumuman ORDER BY id DESC LIMIT 3");
                if(mysqli_num_rows($q_info) > 0) {
                    while($p = mysqli_fetch_array($q_info)){
                ?>
                <div class="col-md-4" data-aos="fade-up">
                    <div class="card h-100 border-0 shadow-sm">
                        <div class="card-body p-4">
                            <span class="badge bg-primary mb-2"><?= $p['jenis'] ?></span>
                            <small class="text-muted d-block mb-2"><?= date('d F Y', strtotime($p['tanggal'])) ?></small>
                            <h5 class="card-title fw-bold"><?= $p['judul'] ?></h5>
                            <p class="card-text text-secondary text-truncate"><?= $p['isi'] ?></p>
                            <a href="#" class="text-decoration-none fw-bold">Baca Selengkapnya <i class="bi bi-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <?php 
                    }
                } else {
                    echo "<div class='col-12 text-center text-muted'>Belum ada pengumuman saat ini.</div>";
                } 
                ?>
            </div>
        </div>
    </section>

    <!-- FOOTER -->
    <footer class="bg-dark text-white py-4 text-center">
        <div class="container">
            <p class="mb-0">&copy; 2025 SMA 1 CONTOH. All Rights Reserved.</p>
            <small class="text-white-50">Developed with ❤️ by Tim IT Sekolah</small>
        </div>
    </footer>

    <!-- SCRIPTS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script>
        AOS.init(); // Inisialisasi Animasi Scroll

        // Navbar berubah warna saat scroll
        window.addEventListener('scroll', function() {
            if (window.scrollY > 50) {
                document.querySelector('.navbar').classList.add('navbar-scrolled');
                document.querySelector('.navbar').classList.remove('navbar-dark');
                document.querySelector('.navbar').classList.add('navbar-light');
            } else {
                document.querySelector('.navbar').classList.remove('navbar-scrolled');
                document.querySelector('.navbar').classList.add('navbar-dark');
                document.querySelector('.navbar').classList.remove('navbar-light');
            }
        });
    </script>
</body>
</html>